n, W, eps = input().split()
n = int(n)
W = int(W)
eps = float(eps)

items = []
for i in range(n):
    wi, vi = map(int, input().split())
    items.append((wi, vi, i + 1))

vmax = max(v for _, v, _ in items)

K = eps * vmax / n
if K == 0:
    K = 1e-9

scaled = []
for wi, vi, idx in items:
    svi = int(vi / K)
    scaled.append((wi, svi, idx))

maxS = sum(sv for _, sv, _ in scaled)
INF = 10**18

dp = [INF] * (maxS + 1)
dp[0] = 0

p = [[False] * (maxS + 1) for _ in range(n)]

for i in range(n):
    wi, svi, _ = scaled[i]
    for s in range(maxS, svi - 1, -1):
        if dp[s - svi] + wi < dp[s]:
            dp[s] = dp[s - svi] + wi
            p[i][s] = True

bestS = max(s for s in range(maxS + 1) if dp[s] <= W)

res = []
cur = bestS
for i in range(n - 1, -1, -1):
    if cur >= 0 and p[i][cur]:
        wi, svi, idx = scaled[i]
        res.append(idx)
        cur -= svi

res.reverse()

print(len(res))
print(*res)